<?php

class Database
{
    private string $host;
    private string $user;
    private string $password;
    private string $database;
    private mysqli $connection;

    public function __construct(string $host, string $user, string $password, string $database)
    {
        $this->host = $host;
        $this->user = $user;
        $this->password = $password;
        $this->database = $database;
        $this->connect();
    }
    public function getUser(int $userId): array
    {
        $stmt = $this->query("SELECT * FROM Users WHERE UserId = $userId");
        if ($stmt->num_rows > 0) {
            return $stmt->fetch_assoc();
        } else {
            $this->query("INSERT INTO Users (UserId) VALUES ($userId)");
            return $this->getUser($userId);
        }
    }
    public function setUserStep(int $userId, string $step): void
    {
        $this->query("UPDATE Users SET Step = '$step' WHERE UserId = $userId");
    }
    public function addPostToDelete(int $channelId, int $messageId, int $deleteTime): void
    {
        $this->query("INSERT INTO CleanList (ChannelId, MessageId, DeleteTime) VALUES ($channelId, $messageId, $deleteTime)");
    }
    public function getPostsToDelete(): array
    {
        $currentTime = time();
        $stmt = $this->query("SELECT * FROM CleanList WHERE DeleteTime <= $currentTime");
        if ($stmt->num_rows > 0) {
            return $stmt->fetch_all(MYSQLI_ASSOC);
        }
        return [];
    }
    public function getCleanList(): array
    {
        $stmt = $this->query("SELECT * FROM CleanList");
        if ($stmt->num_rows > 0) {
            return $stmt->fetch_all(MYSQLI_ASSOC);
        }
        return [];
    }
    public function removePostToDelete(int $channelId, int $channelMessageId): void
    {
        $this->query("DELETE FROM CleanList WHERE ChannelId = $channelId AND MessageId = $channelMessageId");
    }
    public function addPostToUnpin(int $channelId, int $channelMessageId, int $unpinTime)
    {
        $this->query("INSERT INTO UnpinList (ChannelId, MessageId, UnpinTime) VALUES ($channelId, $channelMessageId, $unpinTime)");
    }
    public function getPostsToUnpin(): array
    {
        $currentTime = time();
        $stmt = $this->query("SELECT * FROM UnpinList WHERE UnpinTime <= $currentTime");
        if ($stmt->num_rows > 0) {
            return $stmt->fetch_all(MYSQLI_ASSOC);
        }
        return [];
    }
    public function getUnpinList(): array
    {
        $stmt = $this->query("SELECT * FROM UnpinList");
        if ($stmt->num_rows > 0) {
            return $stmt->fetch_all(MYSQLI_ASSOC);
        }
        return [];
    }
    public function removePostToUnpin(int $channelId, int $channelMessageId): void
    {
        $this->query("DELETE FROM UnpinList WHERE ChannelId = $channelId AND MessageId = $channelMessageId");
    }
    private function connect(): void
    {
        $this->connection = new mysqli($this->host, $this->user, $this->password, $this->database);
        if ($this->connection->connect_error) {
            throw new Exception('Database connection failed: ' . $this->connection->connect_error);
        }
    }
    public function query(string $sql): mysqli_result|bool
    {
        $result = $this->connection->query($sql);
        if ($this->connection->error) {
            throw new Exception('Database query failed: ' . $this->connection->error);
        }
        return $result;
    }
    public function escape(string $string): string
    {
        return $this->connection->real_escape_string($string);
    }
    public function close(): void
    {
        $this->connection->close();
    }
    public function __destruct()
    {
        $this->close();
    }
}
