<?php

global $telegram, $database;
require_once __DIR__ . '/../TelegramInit.php';

$posts = $database->getPostsToDelete();
foreach ($posts as $post) {
    $channelId = $post['ChannelId'];
    $channelMessageId = $post['MessageId'];
    $deleteTime = $post['DeleteTime'];
    $messageLink = "https://t.me/c/".str_replace('-100', '', $channelId)."/$channelMessageId";

    if ($deleteTime <= time()) {
        try {
            try {
                $telegram->deleteMessage($channelId, $channelMessageId);
            } catch (Throwable $e) {
                $errorMessage = $e->getMessage();
                $telegram->sendMessageToMultipleUsers(TELEGRAM_ADMINS, 'حذف پیام ' . $messageLink . ' ناموفق بود: ' . $errorMessage);
            }
            $database->removePostToDelete($channelId, $channelMessageId);
            $telegram->sendMessageToMultipleUsers(TELEGRAM_ADMINS, "پیام $messageLink حذف شد");
        } catch (Throwable $e) {
            $errorMessage = $e->getMessage();
            $telegram->sendMessageToMultipleUsers(TELEGRAM_ADMINS, 'حذف پیام ' . $messageLink . ' ناموفق بود: ' . $errorMessage);
        }
    }
}