<?php

global $database, $telegram;
require_once __DIR__ . '/../TelegramInit.php';


$callbackQuery = $update->callback_query ?? null;
$chatId = $callbackQuery->message->chat->id ?? null;
$callbackData = $callbackQuery->data ?? null;
$fromId = $callbackQuery->from->id ?? null;

if (preg_match('~^delete (-\d+) (\d+)$~', $callbackData, $match)) {
    $channelId = $match[1];
    $channelMessageId = $match[2];
    $telegram->editMessageText(
        chatId: $chatId,
        messageId: $callbackQuery->message->message_id,
        text: 'لطفاً زمانی را برای حذف پیام انتخاب کنید:',
        replyMarkup: Keyboards::chooseTime($channelId, $channelMessageId)
    );
}
elseif (preg_match('~^delete (-\d+) (\d+) (\d+)$~', $callbackData, $match)) {
    $channelId = $match[1];
    $channelMessageId = $match[2];
    $time = (int) $match[3];
    try {
        $admins = $telegram->getChatAdministrators($channelId);
    } catch (Throwable) {
        $telegram->sendMessage(
            chatId: $chatId,
            text: 'شناسه کانال نامعتبر است.',
            replyParameters: [
                'message_id' => $callbackQuery->message->message_id,
                'chat_id' => $chatId,
            ]
        );
        exit();
    }
    if (!$telegram->canDelete($channelId, BOT_ID)) {
        $telegram->sendMessage(
            chatId: $chatId,
            text: 'من اجازه حذف پیام‌ها در این کانال را ندارم.',
            replyParameters: [
                'message_id' => $callbackQuery->message->message_id,
                'chat_id' => $chatId,
            ]
        );
        exit();
    }
    $deleteTime = time() + $time;
    $database->addPostToDelete($channelId, $channelMessageId, $deleteTime);
    $telegram->editMessageText(
        chatId: $chatId,
        messageId: $callbackQuery->message->message_id,
        text: 'پیام در ' . $time . ' ثانیه حذف خواهد شد.',
    );
}
elseif (preg_match('~^unpin (-\d+) (\d+)$~', $callbackData, $match)) {
    $channelId = $match[1];
    $channelMessageId = $match[2];
    $telegram->editMessageText(
        chatId: $chatId,
        messageId: $callbackQuery->message->message_id,
        text: 'لطفاً زمانی را برای لغو سنجاق پیام انتخاب کنید:',
        replyMarkup: Keyboards::chooseTime($channelId, $channelMessageId, true)
    );
}
elseif (preg_match('~^unpin (-\d+) (\d+) (\d+)$~', $callbackData, $match)) {
    $channelId = $match[1];
    $channelMessageId = $match[2];
    $time = (int) $match[3];
    try {
        $admins = $telegram->getChatAdministrators($channelId);
    } catch (Throwable) {
        $telegram->sendMessage(
            chatId: $chatId,
            text: 'شناسه کانال نامعتبر است.',
            replyParameters: [
                'message_id' => $callbackQuery->message->message_id,
                'chat_id' => $chatId,
            ]
        );
        exit();
    }
    $deleteTime = time() + $time;
    $database->addPostToUnpin($channelId, $channelMessageId, $deleteTime);
    $telegram->editMessageText(
        chatId: $chatId,
        messageId: $callbackQuery->message->message_id,
        text: 'پیام در ' . $time . ' ثانیه لغو سنجاق خواهد شد.',
    );
}
