<?php

global $database, $telegram;
require_once __DIR__ . '/../TelegramInit.php';

$chatId = $update->message->chat->id ?? null;
$text = $update->message->text ?? null;
$messageId = $update->message->message_id ?? null;

$user = $database->getUser($chatId);
$step = $user['Step'];

if ($text === '/start') {
    $database->setUserStep($chatId, '');
    $telegram->sendMessage(
        chatId: $chatId,
        text: 'خوش آمدید! لطفاً یک گزینه را انتخاب کنید:',
        replyMarkup: Keyboards::main()
    );
}
elseif (preg_match('~^https://.+/(.+)/(\d+)$~', $text, $match)) {
    $channel = $match[1];
    if (!is_numeric($channel)) {
        $channel = '@' . $channel;
    }
    $channelMessageId = $match[2];
    try {
        $channel = $telegram->getChat($channel);
        $channelId = $channel['result']['id'];
        $telegram->sendMessage(
            chatId: $chatId,
            text: 'لطفاً انتخاب کنید که با پیام چه کاری انجام دهید:',
            replyParameters: [
                'message_id' => $messageId,
                'chat_id' => $chatId,
            ],
            replyMarkup: Keyboards::deleteOrUnpin($channelId, $channelMessageId)
        );
    } catch (Exception $e) {
        $telegram->sendMessage(
            chatId: $chatId,
            text: 'شناسه کانال یا پیام نامعتبر است.',
            replyParameters: [
                'message_id' => $messageId,
                'chat_id' => $chatId,
            ]
        );
        exit();
    }
}
elseif (isset($update->message->forward_from_chat)) {
    $channelId = $update->message->forward_from_chat->id;
    $channelMessageId = $update->message->forward_from_message_id;
    if ($telegram->canDelete($channelId, BOT_ID)) {
        $telegram->sendMessage(
            chatId: $chatId,
            text: 'لطفاً انتخاب کنید که با پیام چه کاری انجام دهید:',
            replyParameters: [
                'message_id' => $messageId,
                'chat_id' => $chatId,
            ],
            replyMarkup: Keyboards::deleteOrUnpin($channelId, $channelMessageId)
        );
    } else {
        $telegram->sendMessage(
            chatId: $chatId,
            text: 'من اجازه حذف پیام‌ها در این کانال را ندارم.',
            replyParameters: [
                'message_id' => $messageId,
                'chat_id' => $chatId,
            ]
        );
    }
}
elseif ($text === 'لیست انتظار') {
    $posts = $database->getCleanList();
    if (empty($posts)) {
        $telegram->sendMessage(
            chatId: $chatId,
            text: 'هیچ پیامی در صف حذف وجود ندارد.',
            replyParameters: [
                'message_id' => $messageId,
                'chat_id' => $chatId,
            ]
        );
    } else {
        $response = "پیام‌ها در صف حذف:\n";
        foreach ($posts as $post) {
            $channelId = $post['ChannelId'];
            $channelMessageId = $post['MessageId'];
            $deleteTime = date('Y-m-d H:i:s', $post['DeleteTime']);
            $messageLink = "https://t.me/c/" . str_replace('-100', '', $channelId) . "/$channelMessageId";
            $response .= "پیام: $messageLink  زمان حذف: $deleteTime\n";
        }
        $telegram->sendMessage(
            chatId: $chatId,
            text: $response,
            replyParameters: [
                'message_id' => $messageId,
                'chat_id' => $chatId,
            ]
        );
    }
    $unpin = $database->getUnpinList();
    if (empty($unpin)) {
        $telegram->sendMessage(
            chatId: $chatId,
            text: 'هیچ پیامی در صف لغو سنجاق وجود ندارد.',
            replyParameters: [
                'message_id' => $messageId,
                'chat_id' => $chatId,
            ]
        );
    } else {
        $response = "پیام‌ها در صف لغو سنجاق:\n";
        foreach ($unpin as $post) {
            $channelId = $post['ChannelId'];
            $channelMessageId = $post['MessageId'];
            $unpinTime = date('Y-m-d H:i:s', $post['UnpinTime']);
            $messageLink = "https://t.me/c/" . str_replace('-100', '', $channelId) . "/$channelMessageId";
            $response .= "پیام: $messageLink  زمان لغو سنجاق: $unpinTime\n";
        }
        $telegram->sendMessage(
            chatId: $chatId,
            text: $response,
            replyParameters: [
                'message_id' => $messageId,
                'chat_id' => $chatId,
            ]
        );
    }
}
